QuShape
====================================================================
QuShape is a comprehensive, platform-independent, user-friendly, and
complete software package that enables efficient, reliable, highly
automated, and accurate analysis of high-throughput capillary
electrophoresis-detected nucleic acid chemical probing experiments.

In QuShape, rapid and efficient algorithms are implemented to yield
objective nucleotide reactivity information with minimal user
supervision. Capillary electrophoresis data from any class of nucleic
acid reactivity probing experiment – including SHAPE, conventional,
hydroxyl radical, and enzyme-based – can be analyzed.

QuShape is self-contained and runs under Windows, MacOS/X, and Linux.
All tools and methods are implemented using Python. PyQt is used for
designing the user interface; NumPy and SciPy to manipulate data and
arrays; and Matplotlib, a Python 2D plotting library, to produce
figures. All packages are open-source software. QuShape has an
extensive help guide and user tutorial.

 

References
---------------------------------------------------------------------
F. Karabiber, J.L. McGinnis, O.V. Favorov and K.M. Weeks, QuShape:
Rapid, accurate, and best-practices quantification of nucleic acid
probing information, resolved by capillary electrophoresis. RNA 19,
63–73 (2013).  [link](https://www.ncbi.nlm.nih.gov/pubmed/23188808)
[pdf](https://webshare.oasis.unc.edu/weeksgroup/pdf-files/2013_fk_rna.pdf)

C.W. Leonard, C.E. Hajdin, F. Karabiber, D.H. Mathews, O.V. Favorov,
N.V. Dokholyan and K.M. Weeks, Principles for understanding the
accuracy of SHAPE-directed RNA structure modeling. Biochemistry 52,
588-595 (2013).  [link](https://www.ncbi.nlm.nih.gov/pubmed/23316814)
[pdf](https://webshare.oasis.unc.edu/weeksgroup/pdf-files/2013_cl_bch.pdf)

 

Software, Installation Guide, and Help
---------------------------------------------------------------------
* [Installation Guide](./installation.md)
* [Python Source Code](./src/)
* [QuShape Tutorial](./QuShape_Tutorial.pdf)
* [Practice Data](./TPP_Practice_Data)
