import shelve

from copy import deepcopy

from PyQt5 import QtCore, QtWidgets

from Dialogs.Functions.funcFile import readShapeData
from Dialogs.Functions import funcGeneral as fGen
from Dialogs.myWidgets import myHBoxLayout

msgAbout = """<b>QuShape</b> v %s
            <p>Copyright &copy; 2010 Weeks Lab.
            <p>University of North Carolina at Chapel Hill
            <p>All rights reserved.
            <p>This application can be used to extract quantitative
            nucleic acid reactivity information """


# <p>Python %s - Qt %s - PyQt %s on %s""" % (
#    __version__, platform.python_version(),
#    QtCore.QT_VERSION_STR, QtCore.PYQT_VERSION_STR, platform.system())


def myGetOpenFileName(workingDir):
    getOpenFileName = QtWidgets.QFileDialog.getOpenFileName(
            None, "Select a file", workingDir, "QuShape project file (*.qushape *.pyshape *.txt *.fsa)")
    if isinstance(getOpenFileName, tuple):
        projFileName = str(getOpenFileName[0])
    else:
        projFileName = str(getOpenFileName)

    return projFileName


def openProjFile(projFileName):
    extFile = QtCore.QFileInfo(projFileName).suffix()
    if extFile == 'txt' or extFile == 'fsa':
        data, Satd, dyes = readShapeData(str(projFileName))
        dProject = fGen.DProjectNew()
        dProject['dData']['RX'] = data[:, 0]
        dProject['dData']['BG'] = data[:, 1]
        dProject['dData']['RXS1'] = data[:, 2]
        dProject['dData']['BGS1'] = data[:, 3]
        dProject['Satd']['RX'] = Satd
        dProject['Satd']['BG'] = Satd
        dProject['dyeN']['RX'] = dyes[0]
        dProject['dyeN']['BG'] = dyes[1]
        dProject['dyeN']['RXS1'] = dyes[2]
        dProject['dyeN']['BGS1'] = dyes[3]

        dProject['scriptList'].append("New Project")

        dProjRef = fGen.DProjectNew()
        dVar = fGen.DVar(dProject['chKeyRS'])
        intervalData = []
        intervalData.append(deepcopy(dProject))
    else:
        dBase = shelve.open(projFileName)
        dProject = deepcopy(dBase['dProject'])
        intervalData = deepcopy(dBase['intervalData'])

        if 'OfSc' in dProject.keys():
            dProject['Satd'] = {}
            dProject['Satd'] = dProject['OfSc']
            del dProject['OfSc']

        if 'dProjRef' in dBase.keys():
            dProjRef = deepcopy(dBase['dProjRef'])
        else:
            dProjRef = fGen.DProjectNew()

        if 'dVar' in dBase.keys():
            dVar = deepcopy(dBase['dVar'])
        else:
            dVar = fGen.DVar(dProject['chKeyRS'])

        for key in fGen.DVar(dProject['chKeyRS']).keys():
            if key not in dVar.keys():
                dVar[key] = fGen.DVar(dProject['chKeyRS'])[key]
        dBase.close()

    dProject['fName'] = str(projFileName)

    return dProject, dVar, intervalData, dProjRef


class MainTopWidget(QtWidgets.QWidget):
    def __init__(self, parent=None):
        QtWidgets.QWidget.__init__(self, parent)

        layoutDataTrack = myHBoxLayout()
        self.labelCh = {}
        for key in fGen.chKeysRS:
            self.labelCh[key] = QtWidgets.QLabel(self.tr(key))
            self.labelCh[key].setFixedWidth(30)
            self.labelCh[key].setAlignment(QtCore.Qt.AlignCenter)
            # self.labelCh[key].setFixedSize(30, 20)

            layoutDataTrack.addWidget(self.labelCh[key])

        groupBoxDataTrack = QtWidgets.QGroupBox(self.tr('Channels'))
        groupBoxDataTrack.setLayout(layoutDataTrack)

        self.splitComboBox = QtWidgets.QComboBox()
        self.splitComboBox.addItems(["Standard", "Reaction/Seqencing", "One Panel", "By Capillary"])
        self.splitComboBox.setToolTip("Split the Channels")
        self.splitComboBox.setWhatsThis(
                'This combo box is used to draw the data in difference view. '
                ' (1) Standard: The channels are plotted separately'
                ' (2) Reaction/Sequencing: The Reagent channels (RX and BG) is plotted in one axes, '
                'The sequencing channels are drawn in the same axis'
                ' (3) By Capillary : (+) Capillary (RX, RXS and RXS1) and (-) Capillary (BG, BGS1, BGS2) is ploteed in seperate axisi'
                ' (4) One Panel: All channels are plotted in one axes')

        layoutSplitCombo = myHBoxLayout()
        layoutSplitCombo.addWidget(self.splitComboBox)
        groupBox2 = QtWidgets.QGroupBox(self.tr('Split Channels'))
        groupBox2.setLayout(layoutSplitCombo)

        labelWidth = QtWidgets.QLabel("W")
        self.spinBoxWidth = QtWidgets.QSpinBox()
        self.spinBoxWidth.setRange(10, 300)
        self.spinBoxWidth.setValue(100)
        self.spinBoxWidth.setSingleStep(10)
        self.spinBoxWidth.setSuffix(" %")
        self.spinBoxWidth.setToolTip("Change the Width")

        labelHeight = QtWidgets.QLabel("H")
        self.spinBoxHeight = QtWidgets.QSpinBox()
        self.spinBoxHeight.setRange(10, 300)
        self.spinBoxHeight.setValue(100)
        self.spinBoxHeight.setSingleStep(10)
        self.spinBoxHeight.setSuffix(" %")
        self.spinBoxHeight.setToolTip("Change the height")

        self.checkBoxFitWindow = QtWidgets.QCheckBox("Fit")
        self.checkBoxFitWindow.setChecked(True)
        self.checkBoxFitWindow.setToolTip("Fit to Window")

        labelZoom = QtWidgets.QLabel("Z")
        self.spinBoxZoom = QtWidgets.QSpinBox()
        self.spinBoxZoom.setRange(1, 999)
        self.spinBoxZoom.setValue(100)
        self.spinBoxZoom.setSingleStep(25)
        self.spinBoxZoom.setSuffix(" %")
        self.spinBoxZoom.setToolTip("Zoom the image")

        layoutResize = myHBoxLayout()
        layoutResize.addWidget(labelWidth)
        layoutResize.addWidget(self.spinBoxWidth)
        layoutResize.addWidget(labelHeight)
        layoutResize.addWidget(self.spinBoxHeight)
        layoutResize.addWidget(labelZoom)
        layoutResize.addWidget(self.spinBoxZoom)
        layoutResize.addWidget(self.checkBoxFitWindow)

        groupBoxResize = QtWidgets.QGroupBox(self.tr('Figure Options'))
        groupBoxResize.setLayout(layoutResize)

        ### TOP LAYOUT
        layoutTop = QtWidgets.QHBoxLayout()
        layoutTop.addWidget(groupBoxDataTrack)
        layoutTop.addWidget(groupBoxResize)
        layoutTop.addWidget(groupBox2)
        layoutTop.setContentsMargins(0, 0, 0, 0)
        layoutTop.setSpacing(1)
        layoutTop.addStretch()

        self.setLayout(layoutTop)


class ToolDock(QtWidgets.QDockWidget):
    def __init__(self, label, parent=None):
        QtWidgets.QDockWidget.__init__(self, parent)
        self.setWindowTitle('Tool Inspector')
        #   self.setFixedSize(250, 350)
        self.setAllowedAreas(QtCore.Qt.LeftDockWidgetArea | QtCore.Qt.RightDockWidgetArea)
        # self.connect(self, QtCore.SIGNAL("topLevelChanged(bool)"), self.dockToolLocationChanged)
        self.topLevelChanged.connect(self.dockToolLocationChanged)

    def dockToolLocationChanged(self):
        if self.isFloating():
            self.setMinimumSize(300, 400)
            self.setMaximumSize(600, 800)
        else:
            self.setFixedSize(300, 400)
